 ; Ŀ
 ;   Bisk - remove a block from other blocks.                              
 ;   Copyright 2002 by Rocket Software Ltd.                                
 ;   Isn't any form of information a virus?                                
 ; 

 ; Ŀ
 ;   Feast - find all blocks with a named one as a subentity.              
 ;   Takes one argument, a block name.                                     
 ;   Calls nothing, returns a list of block names.                         
 ;   Only does one level of nesting, that being all that is needed.        
 ; 
 (DEFUN FEAST (klist / rewind blok blnam enam bleent curnam folist)
 ; Ŀ
 ;   Step through the block table, look for the block as a subentity.      
 ; 
  (setq rewind t)                                   ; set the rewind flag
  (while (setq blok (tblnext "block" rewind))       ; next block in table
         (setq rewind ())                           ; clear the rewind flag
 ; Ŀ
 ;   Save the block name.                                                  
 ; 
         (setq blnam (cdr (assoc 2 blok)))
 ; Ŀ
 ;   Get the name of the first subentity.                                  
 ; 
         (setq enam (cdr (assoc -2 blok)))          ; entity name
         (while enam
               (setq bleent (entget enam))          ; and entity data
               (if (setq curnam (cdr (assoc 2 bleent)))
                   (setq curnam (strcase curnam t)))
               (if (and curnam
                        (member curnam klist)
                        (not (member blnam folist)))
                   (setq folist (cons blnam folist)))
               (setq enam (entnext enam))))
 folist)
 ; Ŀ
 ;   Feast end.  Sadly.                                                    
 ; 

 ; Ŀ
 ;   Morloc - explode an entity, return an ss of the new subentities.      
 ;   Takes one argument, an entity name.                                   
 ; 
 (DEFUN MORLOC (enam / aaa ss)
 ; Ŀ
 ;   Find the last entity in the drawing.                                  
 ; 
  (setq aaa (entlast))
  (while (entnext aaa)
         (setq aaa (entnext aaa)))
 ; Ŀ
 ;   Explode the entity.                                                   
 ; 
  (command ".explode" enam)
 ; Ŀ
 ;   Find the debris left by the explosion.                                
 ; 
  (setq ss (ssadd))
  (while (setq aaa (entnext aaa))
         (ssadd aaa ss))
 ss)
 ; Ŀ
 ;   Morloc end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Bisk - remanufacture a block.                              
 ;   Arguments: Blnam, a block name.                                       
 ;              Klist, a list of block names to remove.                    
 ; 
 (DEFUN BISK (blnam klist / ss num sub enam curnam)
  (command ".insert" blnam "0,0,0" 1 "")
  (while (= 1 (getvar "cmdactive")) (command ""))
  (setq ss (morloc (entlast)))
  (setq num 0)
  (while (setq sub (ssname ss num))
         (if (setq curnam (cdr (assoc 2 (entget sub))))
             (setq curnam (strcase curnam t)))
         (if (and curnam (member curnam klist))
             (entdel sub))
         (setq num (1+ num)))
  (command ".block" blnam "y" "0,0,0" ss ""))
 ; Ŀ
 ;   Subroutine Bisk end.                                                  
 ; 

 ; Ŀ
 ;   Bisk.                                                                 
 ; 
 (DEFUN C:BISK (/ klist blist bnum blnam)
  (setvar "cmdecho" 0)
  (setvar "attdia" 0)
  (setq klist '("block1" "block2" "block3" "etc"))
  (setq blist (feast klist))
  (setq bnum 0)
  (while (setq blnam (nth bnum blist))
         (print blnam)
         (setq bnum (1+ bnum))
         (bisk blnam klist))
 (princ))